--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdsimSurface ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCpopupMenu   = undefined

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNmakeDsimSurfacePopUpMenu FUNlv =
  (
    DYNdsimSurface.LOCpopupMenu = undefined
    if DYNdsimSurface.dnListView1.Items.count > 0 then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll        checked:false\n"
      LOCexe += "  menuItem  MNDYNselectNone       checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  menuItem  MNDYNselectHighAll    checked:false\n"
      LOCexe += "  menuItem  MNDYNselectHighNone   checked:false\n"
      LOCexe += "  separator MNDYNseparator2\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[5] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll  checked:false\n"
      LOCexe += "    menuItem  MNDYNselectTypeNone checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectAll.text      = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectNone.text     = DYNuiResourcesMenus[15]\n"
      LOCexe += "    MNDYNselectHighAll.text  = DYNuiResourcesMenus[16]\n"
      LOCexe += "    MNDYNselectHighNone.text = DYNuiResourcesMenus[17]\n"
      LOCexe += "    MNDYNselectTypeAll.text  = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectTypeNone.text = DYNuiResourcesMenus[19]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll  picked do (for i = 1 to DYNdsimSurface.dnListView1.Items.count do (DYNdsimSurface.dnListView1.Items.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectNone picked do (for i = 1 to DYNdsimSurface.dnListView1.Items.count do (DYNdsimSurface.dnListView1.Items.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectHighAll  picked do (for i = 1 to DYNdsimSurface.dnListView1.SelectedItems.count do (DYNdsimSurface.dnListView1.SelectedItems.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectHighNone picked do (for i = 1 to DYNdsimSurface.dnListView1.SelectedItems.count do (DYNdsimSurface.dnListView1.SelectedItems.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectTypeAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = (filterString DYNdsimSurface.dnListView1.selectedItems.item[0].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "    for i = 1 to DYNdsimSurface.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = (filterString DYNdsimSurface.dnListView1.Items.item[i-1].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNdsimSurface.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectTypeNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = (filterString DYNdsimSurface.dnListView1.selectedItems.item[0].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "    for i = 1 to DYNdsimSurface.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = (filterString DYNdsimSurface.dnListView1.Items.item[i-1].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNdsimSurface.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNdsimSurface.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNdsimSurface.LOCpopupMenu
    )
  )

  fn DSIMFUNdisplayCheckBoxes FUNcaption1 FUNcaption2 FUNarray FUNbitArray FUNminBearing FUNmaxBearing FUNfaceCntArray FUNmatIDarray =
  (
    ExeStr =("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
    ExeStr+=("(\n")
    ExeStr+=("  local LOCresult = #(" + (FUNbitArray as string) + "," + (FUNminBearing as string) + "," + (FUNmaxBearing as string) + "," + (FUNfaceCntArray as string) + "," + (FUNmatIDarray as string) + ")\n")

    ExeStr+=("  label LBDYNlabel width:380 height:60\n")
    ExeStr+=("  dotNetControl dnListView \"System.Windows.Forms.ListView\"    pos:[8,68] width:380 height:145 align:#center\n")
    ExeStr+=("  label   LBDYNangleMin pos:[18,240] height:40 width:240\n")
    ExeStr+=("  label   LBDYNangleMax pos:[18,270] height:40 width:240\n")
    ExeStr+=("  spinner SPDYNangleMin pos:[265,245] range:[0.0,360,0.0] fieldwidth:80\n")
    ExeStr+=("  spinner SPDYNangleMax pos:[265,275] range:[0.0,360,360.0] fieldwidth:80\n")
    ExeStr+=("  groupbox GBDYNgroup01 pos:[8,220] width:381 height:84\n")
    ExeStr+=("  button BUDYNokok DYNuiResourcesButtons[1] width:84 pos:[216,313]\n")
    ExeStr+=("  button BUDYNcanc DYNuiResourcesButtons[3] width:84 pos:[305,313]\n")
    ExeStr+=("  on DYNrollout open do\n")
    ExeStr+=("  (\n")
    ExeStr+=("    SPDYNangleMin.value = LOCresult[2]\n")
    ExeStr+=("    SPDYNangleMax.value = LOCresult[3]\n")
    ExeStr+=("    GBDYNgroup01.text   = DYNuiResourcesGroups[107]\n")
    ExeStr+=("    LBDYNlabel.text     = DYNuiResourcesLabels[366]\n")
    ExeStr+=("    LBDYNangleMin.text  = DYNuiResourcesLabels[367]\n")
    ExeStr+=("    LBDYNangleMax.text  = DYNuiResourcesLabels[368]\n")
    ExeStr+=("    DYNFUNdnListViewStyle dnListView true true\n")
    ExeStr+=("    dnListView.smallimageList = DYNdnSmImageList\n")
    ExeStr+=("    dnListView.Columns.add DYNuiResourcesLvColumns[67] 250\n")
    ExeStr+=("    dnListView.Columns.add DYNuiResourcesLvColumns[62] 105\n")
    ExeStr+=("    dnListView.Columns.item[0].TextAlign =  (dotNetClass \"System.Windows.Forms.HorizontalAlignment\").Left\n")
    ExeStr+=("    dnListView.Columns.item[1].TextAlign =  (dotNetClass \"System.Windows.Forms.HorizontalAlignment\").Center\n")
    ExeStr+=("    local LOCtheRange = #()\n")

    for i = 1 to FUNarray.count do
    (
      ExeStr+=("  local LOCli  = dotNetObject \"System.Windows.Forms.ListViewItem\" \"" + (FUNarray[i] as string) + "\"\n")
      ExeStr+=("  LOCli.tag = " + (i as string) + "\n")
      ExeStr+=("  LOCli.checked = LOCresult[1][" + (i as string) + "]\n")
      ExeStr+=("  local sub_li = LOCli.SubItems.add \"" + (FUNfaceCntArray[i] as string) + "\"\n")
      ExeStr+=("  append LOCtheRange LOCli\n")
    )

    ExeStr+=("    dnListView.Items.AddRange LOCtheRange\n")
    ExeStr+="   )\n"

    ExeStr+="   on SPDYNangleMin changed arg do (LOCresult[2] = arg)\n"
    ExeStr+="   on SPDYNangleMax changed arg do (LOCresult[3] = arg)\n"

    ExeStr+="   on dnListView ItemChecked arg do\n"
    ExeStr+="   (\n"
    ExeStr+="     if arg.item.tag == \"\" then\n"
    ExeStr+="     (\n"
    ExeStr+="       arg.item.checked = false\n"
    ExeStr+="     )\n"
    ExeStr+="     else\n"
    ExeStr+="     (\n"
    ExeStr+="       LOCresult[1][arg.item.index + 1] = arg.item.checked\n"
    ExeStr+="     )\n"
    ExeStr+="   )\n"

    ExeStr+="   on BUDYNokok pressed do\n"
    ExeStr+="   (\n"
    ExeStr+="     if LOCresult[1].numberSet > 0 then (destroyDialog DYNrollout) else (messagebox (DYNuiResourcesErrorsWarnings[52]) title:DYNuiResourcesTitlebars[2])\n"
    ExeStr+="   )\n"
    ExeStr+="   on BUDYNcanc pressed do (LOCresult = #(#{}, 0.0, 360.0," + (FUNfaceCntArray as string) + "," + (FUNmatIDarray as string) + "); destroyDialog DYNrollout)\n"
    ExeStr+=")\n"

    local DYNrollout = Execute ExeStr

    createDialog DYNrollout width:400 height:340 modal:true pos:((getDialogPos DYNdsimSurface) + [100,100])
    return DYNrollout.LOCresult
  )

  fn DYNFUNdisplayMatIDlist FUNsurface FUNmasterArray =
  (
    local LOCmatIDoutArray1 = #()
    local LOCmatIDbitArray  = FUNmasterArray
    local LOCmatIDnames     = #()
    local LOCselection      = 0
    if isValidNode FUNsurface then
    (
      callbacks.removescripts id:#DYNdsimSurface
      actionMan.executeAction 0 "300"
      DYNFUNloadVSPnodeCallBacks false
      (
        with redraw off
        (
          local LOCsurface

          --- Special Treatment for swept objects (creates a copy of the specified node automatically)
          if getAppData FUNsurface 422 == "9" then
          (
            LOCsurface = DynLXCollapse FUNsurface
            convertToMesh LOCsurface
          )
          else
          (
            LOCsurface = copy FUNsurface
            convertToMesh LOCsurface
          )

          local LOCmat     = LOCsurface.material
          if LOCmat != undefined then
          (
            if classof LOCmat == multiMaterial then
            (
              LOCmatIDnames = DYNFUNgetMatChannelNames LOCmat true true DYNINImatIDlimit           -- get names of material channels for selected object
            )
            else
            (
              for i = 1 to DYNINImatIDlimit do append LOCmatIDnames (i as string)
            )
          )
          else
          (
            for i = 1 to DYNINImatIDlimit do append LOCmatIDnames (i as string)
          )

          local LOCfaceCnt    = LOCsurface.numfaces                                    -- the number of faces on the current object
          local LOCmatIDarray = #()                                                    -- Create array to hold number of faces assigned to each material ID
          LOCmatIDarray[DYNINImatIDlimit] = 0                                          -- Set number of items in array
          for i = 1 to LOCmatIDarray.count do LOCmatIDarray[i] = 0                     -- set all channels to zero to indicate that no faces use this material channel

          --- Count faces on surface that use each detected material ID
          for i = 1 to LOCfaceCnt do
          (
            if (getFaceMatID LOCsurface i) <= LOCmatIDarray.count then
            (
              LOCmatIDarray[getFaceMatID LOCsurface i] += 1
            )
          )

          --- Apply matID array information to output array
          for i = 1 to LOCmatIDarray.count do
          (
            if LOCmatIDarray[i] != 0 then
            (
              append LOCmatIDoutArray1 LOCmatIDnames[i]
              append LOCmatIDbitArray[4] LOCmatIDarray[i]
              append LOCmatIDbitArray[5] i
            )
          )

          --- Set Up BitArray
          LOCmatIDbitArray[1].count = LOCmatIDoutArray1.count

          delete LOCsurface
          LOCmatIDbitArray = DSIMFUNdisplayCheckBoxes (DYNuiResourcesTitlebars[30] + " [" + FUNsurface.name + "]") DYNuiResourcesLabels[364] LOCmatIDoutArray1 LOCmatIDbitArray[1] LOCmatIDbitArray[2] LOCmatIDbitArray[3] LOCmatIDbitArray[4] LOCmatIDbitArray[5]
        )
      )
      DYNFUNloadVSPnodeCallBacks true
      callbacks.addscript #selectedNodesPreDelete "DYNdsimSurface.DSIMFUNObjectsDeleted()"  id:#DYNdsimSurface
      callbacks.addscript #selectionSetChanged    "DYNdsimSurface.DSIMFUNObjectsSelected()" id:#DYNdsimSurface
    )
    LOCmatIDbitArray -- return value
  )

  fn DSIMFUNobjectsSelected =
  (
    DYNdsimSurface.dnListView1.selecteditems.clear()

    local LOCobjects     = getCurrentSelection()

    for i in LOCobjects do
    (
      local LOClistItem = DYNdsimSurface.dnListView1.items.item[(i.inode.handle as string)]
      if LOClistItem != undefined then (LOClistItem.selected = true)
    )
    if DYNdsimSurface.dnListView1.selecteditems.count > 0 then
    (
      DYNdsimSurface.dnListView1.selectedItems.item[0].ensureVisible()
    )
  )

  fn DSIMFUNobjectsDeleted =
  (
---    --- get array of nodes about to be deleted, or undefined if callback broadcasted
---    local LOCnotifyParam = callbacks.notificationParam()

---    if LOCnotifyParam != undefined then
---    (
---      for i in LOCnotifyParam do
---      (
---        local LOClistItem = DYNdsimSurface.dnListView1.items.item[(i.inode.handle as string)]
---        if LOClistItem != undefined then LOClistItem.remove()
---      )
---    )
  )


  fn DSIMFUNsurfaceTrackingVehicles =
  (
    undo off
    (
      callbacks.removescripts id:#DYNdsimSurface
      DYNFUNremoveCSProllouts()
      actionMan.executeAction 0 "300" -- Ensure that MAX modify panel is NOT open
      DYNFUNloadVSPnodeCallBacks false  -- Enable auto update of Explorer
      (
        with redraw off
        (
          --- Substitue vehicle
          local LOCtotal = DYNdsimSurface.dnListView1.checkedItems.count as float
          local LOCcnt   = 0.0
          local LOCstart = timestamp()
          for i = 1 to DYNdsimSurface.dnListView1.checkeditems.count do
          (
            for ii = 1 to DYNdsimSurface.dnListView3.items.count do
            (
              LOCcnt += (1.0 / DYNdsimSurface.dnListView3.items.count)
              DYNdsimSurface.dnProgress2.value = ((LOCcnt) / (LOCtotal) * 100.0)
              local LOCbaseObj   = maxOps.getNodeByHandle (DYNdsimSurface.dnListView1.checkedItems.item[i-1].name as integer)
              local LOCsurfObj       = maxOps.getNodeByHandle ((filterString DYNdsimSurface.dnListView3.items.item[ii-1].name "|")[1] as integer)
              local LOCselmatIDlist  = try (DYNFUNstripStringSpaces DYNdsimSurface.dnListView3.items.item[ii-1].subItems.item[3].text) catch ("1")
              local LOCselmatIDArray = filterString LOCselmatIDlist ";"
              local LOCangleMin      = try (DYNdsimSurface.dnListView3.items.item[ii-1].subItems.item[4].text as integer) catch (0.0)
              local LOCangleMax      = try (DYNdsimSurface.dnListView3.items.item[ii-1].subItems.item[5].text as integer) catch (360.0)
              local LOCmissedRayCnt  = 0

              for a = 1 to LOCselmatIDArray.count do
              (
                --- Generate copy of LOCsurfObj which includes only selected MatID
                local LOCtempObj

                if getAppData LOCsurfObj 422 == "9" then
                (
                  --- Special Treatment for swept objects (creates a copy of the specified node automatically)
                  LOCtempObj = DynLXCollapse LOCsurfObj
                  convertToMesh LOCtempObj
                )
                else
                (
                  LOCtempObj = copy LOCsurfObj
                  convertToMesh LOCtempObj
                )

                local LOCbitArray = LOCtempObj.Faces as bitArray -- create bitArray of all faces
                for iii = 1 to LOCbitArray.count do              -- filter bitArray to only faces which match curretn matID selection
                (
                  LOCbitArray[iii] = if (getFaceMatID LOCtempObj iii) != (LOCselmatIDArray[a] as integer) then true else false -- deselect faces which do not match selected MatID
                )
                meshop.deleteFaces LOCtempObj LOCbitArray delIsoVerts:true
                update LOCtempObj

                --- Assign New Rotation Controller
                local LOCctrlR      = LOCbaseObj.rotation.controller = bezier_rotation()
                local LOCctrlRkeys  = LOCctrlR.keys

                if LOCbaseObj.scale.controller.float03.controller.keys.count == LOCbaseObj.rotation.keys.count and LOCbaseObj.position.keys.count == LOCbaseObj.rotation.keys.count then
                (
                  --- Update Controller
                  for iii = 1 to LOCbaseObj.pos.controller.keys.count do
                  (
                    --- Check Filter Angle --------
                    local LOCproceedSwitch = true
                    if LOCangleMin != 0.0 and LOCangleMax != 360.0 then
                    (
                      local LOCtestBearing = 180.0 + LOCbaseObj.scale.controller.float03.controller.keys[iii].value
                      if LOCtestBearing < LOCangleMin or LOCtestBearing > LOCangleMax then LOCproceedSwitch = false
                    )

                    --- Apply Surface Tracking --------
                    if LOCproceedSwitch then
                    (
                      --- Process Pos/Rot at each KeyFrame
                      DYNdsimSurface.dnProgress1.value = ((iii as float) / (LOCbaseObj.pos.controller.keys.count as float) * 100.0)
                      DYNdsimSurface.LBDYNstatus.text = DYNuiResourcesStatusMessages[27] + " " + LOCbaseObj.name

                      --- Get Surface Normal At Intersect Point
                      local LOCray = intersectRay LOCtempObj (ray [LOCbaseObj.pos.keys[iii].value.x,LOCbaseObj.pos.keys[iii].value.y,999999.000] [0,0,-1])

                      --- If the ray intersected a surface, then...
                      if LOCray != undefined then
                      (
                        local LOCframe = LOCbaseObj.pos.keys[iii].time

                        --- Update Position Controller (Z From Surface Only)
                        LOCbaseObj.pos.keys[iii].value = LOCray.pos

                        --- Build New Rotation Controller Keys
                        local LOCnewKeyR = addNewKey LOCctrlRkeys (LOCframe)
                        LOCnewKeyR.value = (RotateZ (inverse (matrixFromNormal [LOCray.dir.x, LOCray.dir.y, LOCray.dir.z])) LOCbaseObj.scale.controller.float03.controller.keys[iii].value) as quat
                      )
                      else
                      (
                        LOCmissedRayCnt += 1
                      )
                    )
                  )

                  --- Hack to fix problem with sliding vehicles in 3ds Max "Smooth Rotation" controller when passing throgh N,E,S,W quadrants
                  --- Setting the rotation value to itself seems to remove broken trajectories in these areas.
                  --- This hack was discovered by applying the followign scripted expression to the entire scene (which worked):
                  --- q = $dsim* as array; for i in q do i.rotation = i.rotation
                  LOCbaseObj.rotation = LOCbaseObj.rotation
                )
                else
                (
                  messagebox (LOCbaseObj.name + " : " + DYNuiResourcesErrorsWarnings[51]) title:DYNuiResourcesTitlebars[2]
                )

                --- Delete Temporary Mesh
                delete LOCtempObj
              )
            )
            gc()
          )
          local LOCend = timestamp()
        )
      )
      DYNFUNloadVSPnodeCallBacks true                               -- Enable auto update of Explorer
      DYNFUNnodeCreatedCallback()
      DYNdsimSurface.DSIMFUNfillVehicleList DYNdsimSurface.dnListView1 DYNdsimSurface.dnProgress1 DYNobjHandles[1]
      callbacks.addscript #selectedNodesPreDelete "DYNdsimSurface.DSIMFUNObjectsDeleted()"  id:#DYNdsimSurface
      callbacks.addscript #selectionSetChanged    "DYNdsimSurface.DSIMFUNObjectsSelected()" id:#DYNdsimSurface
      DYNdsimSurface.dnProgress1.value = 0.0
      DYNdsimSurface.dnProgress2.value = 0.0
      DYNdsimSurface.LBDYNstatus.text = DYNuiResourcesStatusMessages[28] + " (" + (((LOCend - LOCstart) / 1000.0) as string) + " " + DYNuiResourcesUnitsTime[2] + ")"
    )

    LOCmodArray --return value
  )

  fn DSIMFUNfillVehicleList FUNlv FUNprogress FUNarray =
  (
    local LOCtheRange = #()
    local LOCcnt = 0

    FUNlv.Items.clear()

    for i in FUNarray do
    (
      FUNprogress.value = ((LOCcnt as float) / (FUNarray.count as float) * 100.0)
      local LOCobj = maxOps.getNodeByHandle i
      if (getAppData LOCobj 421) == "DSIM" then
      (
        local LOCli  = dotNetObject "System.Windows.Forms.ListViewItem" LOCobj.name
        LOCli.name = i as string
        LOCli.imageIndex = 1

        /*
        LOCli.forecolor = (dotNetClass "System.Drawing.Color").fromARGB LOCobj.wirecolor.r LOCobj.wirecolor.g LOCobj.wirecolor.b
        */

        --- Then add all the sub-items with the desired string values:
        local LOCappData425 = filterString (getAppData LOCobj 425) "|"
        local sub_li = LOCli.SubItems.add (try (LOCappData425[3]) catch ("--"))
        local sub_li = LOCli.SubItems.add (try (LOCappData425[4]) catch ("--"))
        local sub_li = LOCli.SubItems.add (try ((LOCobj.pos.controller.keys[1].time) as string) catch ("--"))
        local sub_li = LOCli.SubItems.add (try ((LOCobj.pos.controller.keys[LOCobj.pos.controller.keys.count].time) as string) catch ("--"))
        local sub_li = LOCli.SubItems.add (try ((LOCobj.pos.controller.keys.count) as string) catch ("--"))
        append LOCtheRange LOCli
      )
      LOCcnt += 1
    )
    FUNlv.Items.AddRange LOCtheRange

    --- Highlight all selected DSIM objects in the LV
    DYNdsimSurface.DSIMFUNobjectsSelected()

    --- Finish Off
    DYNdsimSurface.LBDYNstatus.text = DYNuiResourcesStatusMessages[26]
    FUNprogress.value = 0.0
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  button BUDYNselectAll       pos:[8,394]   width:254 height:22 filter:DYNFUNgeometryFilter
  button BUDYNselectNone      pos:[268,394] width:254 height:22 filter:DYNFUNgeometryFilter

  label LBlistView2           pos:[8,437]   width:513

  pickbutton PKDYNsurface     pos:[8,610]   width:254 height:22 filter:DYNFUNgeometryFilter
  button BUDYNnoSur           pos:[268,610] width:254 height:22

  button BUDYNhelp  width:100 pos:[8,660]   height:22
  button BUDYNokok  width:100 pos:[217,660] height:22
  button BUDYNapply width:100 pos:[320,660] height:22
  button BUDYNcanc  width:100 pos:[423,660] height:22

  label LBDYNstatus           pos:[8,710]   width:513 height:18

  dotNetControl dnListView3 "System.Windows.Forms.ListView"    pos:[8,455]   width:513 height:150
  dotNetControl dnListView1 "System.Windows.Forms.ListView"    pos:[8,8]     width:513 height:381 align:#center
  dotNetControl dnProgress1 "System.Windows.Forms.ProgressBar" pos:[8,690]   width:254 height:12
  dotNetControl dnProgress2 "System.Windows.Forms.ProgressBar" pos:[268,690] width:254 height:12

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdsimSurface open do
  (
    DYNdsimSurface.title      = DYNuiRolloutNames[39]
    BUDYNokok.text            = DYNuiResourcesButtons[1]
    BUDYNapply.text           = DYNuiResourcesButtons[2]
    BUDYNcanc.text            = DYNuiResourcesButtons[3]
    BUDYNhelp.text            = DYNuiResourcesButtons[5]
    BUDYNselectAll.text       = DYNuiResourcesButtons[77]
    BUDYNselectNone.text      = DYNuiResourcesButtons[78]
    PKDYNsurface.text         = DYNuiResourcesButtons[79]
    BUDYNnoSur.text           = DYNuiResourcesButtons[80]

    LBlistView2.text          = DYNuiResourcesLabels[365]

    --- Set Up ListView Displays
    DYNFUNdnListViewStyle dnListView1 true true
    dnListView1.smallimageList = DYNdnSmImageList
    dnListView1.Columns.add DYNuiResourcesLvColumns[55] 152
    dnListView1.Columns.add DYNuiResourcesLvColumns[56]  60
    dnListView1.Columns.add DYNuiResourcesLvColumns[57]  60
    dnListView1.Columns.add DYNuiResourcesLvColumns[58]  81
    dnListView1.Columns.add DYNuiResourcesLvColumns[59]  78
    dnListView1.Columns.add DYNuiResourcesLvColumns[60]  60
    dnListView1.Columns.item[0].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[1].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[2].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[3].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[4].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[5].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    DYNFUNdnListViewStyle dnListView3 false true
    dnListView3.smallimageList = DYNdnSmImageList
    dnListView3.Columns.add DYNuiResourcesLvColumns[61] 135
    dnListView3.Columns.add DYNuiResourcesLvColumns[62] 70
    dnListView3.Columns.add DYNuiResourcesLvColumns[63] 80
    dnListView3.Columns.add DYNuiResourcesLvColumns[64] 65
    dnListView3.Columns.add DYNuiResourcesLvColumns[65] 70
    dnListView3.Columns.add DYNuiResourcesLvColumns[66] 75
    dnListView3.Columns.item[1].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView3.Columns.item[2].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView3.Columns.item[3].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView3.Columns.item[4].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView3.Columns.item[5].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView3.multiSelect = false

    DYNFUNnodeCreatedCallback()

    DSIMFUNfillVehicleList dnListView1 dnProgress1 DYNobjHandles[1]

    callbacks.removescripts id:#DYNdsimSurface
    callbacks.addscript #selectedNodesPreDelete "DYNdsimSurface.DSIMFUNObjectsDeleted()"  id:#DYNdsimSurface
    callbacks.addscript #selectionSetChanged    "DYNdsimSurface.DSIMFUNObjectsSelected()" id:#DYNdsimSurface
  )

  on DYNdsimSurface close do
  (
    callbacks.removescripts id:#DYNdsimSurface
  )

  on BUDYNselectAll pressed do
  (
    for i = 1 to dnListView1.items.count do
    (
      dnListView1.items.item[i-1].checked = true
    )
  )

  on BUDYNselectNone pressed do
  (
    for i = 1 to dnListView1.items.count do
    (
      dnListView1.items.item[i-1].checked = false
    )
  )

  on dnListView3 DoubleClick do
  (
    if dnListView3.selectedItems.count == 1 then
    (
      local LOCfilterString  = filterString dnListView3.selectedItems.item[0].name "|"
      local LOCmatIDnames     = #()

      --- Get Material Channel Names
      local LOCmat     = (maxOps.getNodeByHandle (LOCfilterString[1] as integer)).material
      if LOCmat != undefined then
      (
        if classof LOCmat == multiMaterial then
        (
          LOCmatIDnames = DYNFUNgetMatChannelNames LOCmat true true DYNINImatIDlimit
        )
        else
        (
          for i = 1 to DYNINImatIDlimit do append LOCmatIDnames (i as string)
        )
      )
      else
      (
        for i = 1 to DYNINImatIDlimit do append LOCmatIDnames (i as string)
      )
      local LOCmatIDoutArray1 = #()
      for i = 1 to (execute LOCfilterString[6]).count do
      (
        append LOCmatIDoutArray1 LOCmatIDnames[(execute LOCfilterString[6])[i]]
      )

      --- Display Parameters in Panel
      local LOCmatIDbitArray = DSIMFUNdisplayCheckBoxes (DYNuiResourcesTitlebars[30] + " [" + (maxOps.getNodeByHandle (LOCfilterString[1] as integer)).name + "]") DYNuiResourcesLabels[364]  LOCmatIDoutArray1 (execute LOCfilterString[2]) (LOCfilterString[3] as float) (LOCfilterString[4] as float) (execute LOCfilterString[5]) (execute LOCfilterString[6])

      --- Update ListItem
      if LOCmatIDbitArray[1].numberSet > 0 then
      (
        --- Calculate Filtered Face Count
        local LOCfilteredFaces = 0
        for i = 1 to LOCmatIDbitArray[1].count do (if LOCmatIDbitArray[1][i] then (LOCfilteredFaces += LOCmatIDbitArray[4][i]))

        --- Build Delimited String of Selected MatIDs
        local LOCdelimitArray  = #()
        for i = 1 to LOCmatIDbitArray[1].count do (if LOCmatIDbitArray[1][i] then (append LOCdelimitArray LOCmatIDbitArray[5][i]))
        local LOCdelimitString = DYNFUNarray2DelimitedString LOCdelimitArray ";"

        --- Populate Surfaces ListView
        dnListView3.selectedItems.item[0].name = LOCfilterString[1] + "|" + (LOCmatIDbitArray[1] as string) + "|" + (LOCmatIDbitArray[2] as string) + "|" + (LOCmatIDbitArray[3] as string) + "|" + (LOCmatIDbitArray[4] as string) + "|" + (LOCmatIDbitArray[5] as string)
        dnListView3.selectedItems.item[0].SubItems.item[2].text = LOCfilteredFaces as string
        dnListView3.selectedItems.item[0].SubItems.item[3].text = LOCdelimitString
        dnListView3.selectedItems.item[0].SubItems.item[4].text = LOCmatIDbitArray[2] as string
        dnListView3.selectedItems.item[0].SubItems.item[5].text = LOCmatIDbitArray[3] as string
      )
    )
  )

  on PKDYNsurface picked arg do
  (
    local LOCmatIDbitArray     = DYNFUNdisplayMatIDlist arg #(#{}, 0.0, 360.0, #(),#())

    if LOCmatIDbitArray[1].numberSet > 0 then
    (
      --- Calculate Face Count
      local LOCfaces = 0
      for i = 1 to LOCmatIDbitArray[1].count do (LOCfaces += LOCmatIDbitArray[4][i])

      --- Calculate Filtered Face Count
      local LOCfilteredFaces = 0
      for i = 1 to LOCmatIDbitArray[1].count do (if LOCmatIDbitArray[1][i] then (LOCfilteredFaces += LOCmatIDbitArray[4][i]))

      --- Build Delimited String of Selected MatIDs
      local LOCdelimitArray  = #()
      for i = 1 to LOCmatIDbitArray[1].count do (if LOCmatIDbitArray[1][i] then (append LOCdelimitArray LOCmatIDbitArray[5][i]))
      local LOCdelimitString = DYNFUNarray2DelimitedString LOCdelimitArray ";"

      --- Populate Surfaces ListView
      local LOCli  = dotNetObject "System.Windows.Forms.ListViewItem" arg.name -- create a ListViewItem object with the object's name
      LOCli.name   = (arg.inode.handle as string) + "|" + (LOCmatIDbitArray[1] as string) + "|" + (LOCmatIDbitArray[2] as string) + "|" + (LOCmatIDbitArray[3] as string) + "|" + (LOCmatIDbitArray[4] as string) + "|" + (LOCmatIDbitArray[5] as string)
      LOCli.imageIndex = 8
      LOCli.SubItems.add (LOCfaces as string)
      LOCli.SubItems.add (LOCfilteredFaces as string)
      LOCli.SubItems.add LOCdelimitString
      LOCli.SubItems.add (LOCmatIDbitArray[2] as string)
      LOCli.SubItems.add (LOCmatIDbitArray[3] as string)
      dnListView3.Items.AddRange #(LOCli)
    )
  )

  on BUDYNnoSur pressed do
  (
    for i = 1 to dnListView3.selectedItems.count do
    (
      dnListView3.selectedItems.item[i-1].remove()
    )
  )

  on dnListView1 mouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeDsimSurfacePopUpMenu dnListView1
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )

    local LOCnodeArray = #()
    for i = 1 to dnListView1.selectedItems.count do
    (
       local LOCnode = maxOps.getNodeByHandle (dnListView1.selectedItems.item[i-1].name as integer)
       if isValidNode LOCnode then append LOCnodeArray LOCnode
    )
    select LOCnodeArray
  )

  on BUDYNokok pressed do
  (
    if dnListView1.CheckedItems.count > 0 then
    (
      if dnListView3.Items.count > 0 then
      (
        if querybox (DYNuiResourcesQueries[31]) title:DYNuiResourcesTitlebars[3] then
        (
          DSIMFUNsurfaceTrackingVehicles()
          destroyDialog DYNdsimSurface
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[49]) title:DYNuiResourcesTitlebars[3]
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[50]) title:DYNuiResourcesTitlebars[3]
    )
  )

  on BUDYNapply pressed do
  (
    if dnListView1.CheckedItems.count > 0 then
    (
      if dnListView3.Items.count > 0 then
      (
        if querybox (DYNuiResourcesQueries[31]) title:DYNuiResourcesTitlebars[2] then
        (
          DSIMFUNsurfaceTrackingVehicles()
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[49]) title:DYNuiResourcesTitlebars[3]
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[50]) title:DYNuiResourcesTitlebars[3]
    )
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNdsimSurface
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13220 -- id_cv_surface_tracking
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA34CIzOSfVfSjC0QnyHqCafQcWlFiPB1Hx
-- nQf0UJ2r8EqOJfmlDSiwibxxL04vvELTznYS5N8LlCmOt1qmZeR8aqHrtMc/UJ0K
-- gyTzcjeCNWayxC5FQU2TaSYMdMvMXbnSiEps0BFScaz9HX4emd5dkPsuuI0H/9Bu
-- 7nFbKYCj/CyWc/0SZJRm34oGxmjpN+wJBeBfn/eqln7mTzi3pQ9d9mAZUtZZO2HL
-- xpuX9YMG0uNY195icM3BgQjv4hT7CSHA7szP9L9wwnczqptUs4MtSt1Qds49KBFM
-- P5wyBrmzpINxRIh7+vvop0wdubAmLIhlt9k71hg+E6kg6jp6gSE6
-- -----END-SIGNATURE-----